#Collecting miRNA targets

miRNA_search <- function(miRNA) {
  
  try({
    miRNAsearch_request <- GET(paste(api_url, "projects/", project_id, "/miRnas:search", sep =""), query = list(query=miRNA), timeout(100))
    miRNA_targets <- content(miRNAsearch_request, "parsed")
    stop_for_status(miRNAsearch_request)
    
    if(length(miRNA_targets[[1]])==3) {
      if(length(miRNA_targets[[1]][[3]])!=0) {
        miRNA_targets <- miRNA_targets[[1]][[3]]
        print(miRNA)
        miRNA_targets_cleaned <- miRNA_targets[c(sapply(miRNA_targets, function(x) length(x[[4]])!=0&length(x[[3]])!=0))]
        if(length(miRNA_targets_cleaned)==0) { return() }
        
        miRNA_targets_cleaned <- lapply(miRNA_targets_cleaned, function(x) x[[3]])
        miRNA_targets_cleaned <- unlist(miRNA_targets_cleaned, recursive = FALSE)
        
        miRNA_target_names <- lapply(miRNA_targets_cleaned, function(x) id_requesting(x[["id"]]) )
        miRNA_targets_cleaned <- lapply(miRNA_targets_cleaned, function(x) x[[1]])
        miRNA_targets <- data.frame(cbind(miRNA_target_names), cbind(miRNA_targets_cleaned))
        
        colnames(miRNA_targets) <- c(paste("Targets for", miRNA, sep =" "), "id")
        
        return(miRNA_targets)
      }
    }
  })
}

#create list of miRNAs that could act on each target
get_single_query_miRNA_list <- function(targetID) {  
  try( {
    target <- "ALIAS"
    miRNAsearch_request <- GET(paste(api_url, "projects/", project_id, "/miRnas:search?columns=name&target=", target, ":", targetID, sep=""), times = 5, timeout(100))
    miRNA_list = content(miRNAsearch_request, "parsed")
    stop_for_status(miRNAsearch_request)
    miRNA_list <- lapply(miRNA_list, tolower)
    return(unique(miRNA_list))
  })
} 

get_query_miRNA_list <- function() {
  element_names <- get_element_names()
  miRNA_list <- lapply(element_names$id, get_single_query_miRNA_list)  
  miRNA_list <- unlist(miRNA_list)
  miRNA_list <- lapply(miRNA_list, function(x) x)
  return(unique(miRNA_list))
}